#define DDel 5 //IN1 
#define DAtr 6 //IN2
#define IDel 9 //IN3
#define IAtr 10 //IN4

const int EchoPin = 7;
const int TriggerPin = 8;
const int SLD = A0;
const int SLI = A5;
const int HALL = A3;
const int BUZZER = 3;
const int SERVO = 4;
const int LEDR = 11;
const int LEDV = 12;
const int LEDA = 13;


bool estadoServo = false;
int instruccion = 0, luz = 0;

int CalculaDistancia(int TriggerPin, int EchoPin)
{
  long duration, distanceCm;

   //CÁLCULO DE LA DISTANCIA
   digitalWrite(TriggerPin, LOW);  //para generar un pulso limpio ponemos a LOW 4us
   delayMicroseconds(4);
   digitalWrite(TriggerPin, HIGH);  //generamos Trigger (disparo) de 10us
   delayMicroseconds(10);
   digitalWrite(TriggerPin, LOW);
   
   duration = pulseIn(EchoPin, HIGH);  //medimos el tiempo entre pulsos, en microsegundos
   
   distanceCm = duration * 10 / 292/ 2;   //convertimos a distancia, en cm
   //Serial.println (distanceCm);
   return distanceCm;
}

void evitaObstaculos (int distancia)
{
  //DEPENDIENDO DE LA DISTANCIA, HARÁ DIFERENTES COSAS
  
   if((distancia <= 25))
   {
      //Encendido de LEDS
      digitalWrite (LEDR, HIGH);
      digitalWrite (LEDV, LOW);
      digitalWrite (LEDA, LOW);
      //Movimiento
      analogWrite (DDel, 0);
      analogWrite (DAtr, 125);
      analogWrite (IDel, 0);
      analogWrite (IAtr, 125);
      delay (200);
      analogWrite (DDel, 110);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 0);
      analogWrite (IAtr, 65);
      delay (200);
   }else if ((distancia > 25) && (distancia < 55))
   {
      //Encendido de LEDS
      digitalWrite (LEDR, LOW);
      digitalWrite (LEDV, LOW);
      digitalWrite (LEDA, HIGH);
      //Movimiento
      analogWrite (DDel, 125);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 75);
      analogWrite (IAtr, 0);
      delay (100);
   }else if (distancia > 50) //DESPLAZAMIENTO HACIA DELANTE
   {
      //Encendido de LEDS
      digitalWrite (LEDV, HIGH);
      digitalWrite (LEDR, LOW);
      digitalWrite (LEDA, LOW);
      //Movimiento
      analogWrite (DDel, 100);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 96);
      analogWrite (IAtr, 0);
   }
}

void Siguelineas (int SLD,int SLI)
{
  if ((digitalRead (SLD) == LOW) && (digitalRead (SLI) == LOW)) //No se detectan lineas por ninguno de los dos lados
  {
    //Sonido y LEDS
    analogWrite (BUZZER, 0);
    digitalWrite (LEDV, HIGH);
    digitalWrite (LEDR, LOW);
    digitalWrite (LEDA, LOW);
    //Movimiento
    analogWrite (DDel, 100); 
    analogWrite (DAtr, 0);
    analogWrite (IDel, 96);
    analogWrite (IAtr, 0);
  }

  if ((digitalRead (SLD) == HIGH) && (digitalRead (SLI) == LOW)) //Se detecta linea por el lado derecho
  {
    //Sonido y LEDS
    analogWrite (BUZZER, 200);
    digitalWrite (LEDR, HIGH);
    digitalWrite (LEDV, LOW);
    digitalWrite (LEDA, LOW);
    //Movimiento
    analogWrite (DDel, 75);
    analogWrite (DAtr, 0);
    analogWrite (IDel, 0);
    analogWrite (IAtr, 100);
  }

  if ((digitalRead (SLD) == LOW) && (digitalRead (SLI) == HIGH)) //Se detecta linea por el lado izquierdo
  {
    //Sonido y LEDS
    analogWrite (BUZZER, 200);
    digitalWrite (LEDR, LOW);
    digitalWrite (LEDV, LOW);
    digitalWrite (LEDA, HIGH);
    //Movimiento
    analogWrite (DDel, 0);
    analogWrite (DAtr, 100);
    analogWrite (IDel, 75);
    analogWrite (IAtr, 0);
  }
}

void setup() {
   Serial.begin(9600);
   Serial.setTimeout(50);
   pinMode(DDel, OUTPUT);
   pinMode(DAtr, OUTPUT);
   pinMode(IDel, OUTPUT);
   pinMode(IAtr, OUTPUT);
   pinMode(TriggerPin, OUTPUT);
   pinMode(EchoPin, INPUT);
   pinMode(SLD, INPUT);
   pinMode(SLI, INPUT);
   pinMode(HALL, INPUT);
   pinMode(BUZZER, OUTPUT);
   pinMode(SERVO, OUTPUT);
   pinMode(LEDR, OUTPUT);
   pinMode(LEDV, OUTPUT);
   pinMode(LEDA, OUTPUT);

   //ESTADO INICIAL DE LOS MOTORES
   analogWrite (DDel, 0);
   analogWrite (DAtr, 0);
   analogWrite (IDel, 0);
   analogWrite (IAtr, 0);
   
}

void loop() 
{
  int distancia = CalculaDistancia(TriggerPin, EchoPin); //Se cálcula la distancia
  
  if (Serial.available() > 0) //Llega la lectura del modo por el canal serie (bluetooth)
  {
    instruccion = Serial.read();
  }
 
  switch (instruccion)
  {
    case 1: //EVITAOBSTACULOS
      evitaObstaculos (distancia);
    break;

    case 2: //SIGUELINEAS 
      Siguelineas (SLD,SLI);
   
      if (digitalRead (HALL) == 0) //Si el sensor Hall detecta un imán
      {
        analogWrite (DDel, 255);
        analogWrite (DAtr, 0);
        analogWrite (IDel, 255);
        analogWrite (IAtr, 0);
        delay (750);
      }
    break;


    //MODO MANUAL
    
    case 4://FLECHA ARRIBA (HACIA DELANTE)
      analogWrite (DDel, 175);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 170);
      analogWrite (IAtr, 0);
    break;

    case 5://FLECHA ABAJO (HACIA DETRÁS)
      analogWrite (DDel, 0);
      analogWrite (DAtr, 170);
      analogWrite (IDel, 0);
      analogWrite (IAtr, 175);
    break;

    case 6://FLECHA A LA DERECHA (GIRA SOBRE SI MISMO SENTIDO HORARIO)
      analogWrite (DDel, 0);
      analogWrite (DAtr, 170);
      analogWrite (IDel, 170);
      analogWrite (IAtr, 0);
    break;

    case 7://FLECHA A LA IZQUIERDA (GIRA SOBRE SI MISMO SENTIDO ANTIHORARIO)
      analogWrite (DDel, 170);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 0);
      analogWrite (IAtr, 170);
    break;

    case 8://FLECHA DIAGONAL ARRIBA IZQUIERDA (GIRO DELANTE-IZQUIEDA)
      analogWrite (DDel, 170);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 100);
      analogWrite (IAtr, 0);
    break;

    case 9://FLECHA DIAGONAL ARRIBA DERECHA (GIRO DELANTE-DERECHA)
      analogWrite (DDel, 100);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 170);
      analogWrite (IAtr, 0);
    break;

    case 10://FLECHA DIAGONAL ABAJO IZQUIERDA (GIRO ATRAS-IZQUIERDA)
      analogWrite (DDel, 0);
      analogWrite (DAtr, 170);
      analogWrite (IDel, 0);
      analogWrite (IAtr, 100);
    break;

    case 11://FLECHA DIAGONAL ABAJO DERECHA (GIRO ATRAS-DERECHA)
      analogWrite (DDel, 0);
      analogWrite (DAtr, 100);
      analogWrite (IDel, 0);
      analogWrite (IAtr, 170);
    break;

    case 12://PINZA
      if (estadoServo == false)
      {
        for (int Hz = 0; Hz <50; Hz++) //GIRO A 90º
        {
          digitalWrite (SERVO, HIGH);
          delayMicroseconds (1500);
          digitalWrite (SERVO, LOW);
          delay (19);
          estadoServo = true;
        }
      }else
      {
        for (int Hz = 0; Hz <50; Hz++) //GIRO A 0º
        {
          digitalWrite (SERVO, HIGH);
          delayMicroseconds (700);
          digitalWrite (SERVO, LOW);
          delay (20);
          estadoServo = false;
        }
      }
      instruccion = 3; //Entra en el caso default
    break;

    default:
      analogWrite (DDel, 0);
      analogWrite (DAtr, 0);
      analogWrite (IDel, 0);
      analogWrite (IAtr, 0);
    break;
  }
}
