
bool dyor_enable = false; //Habilita el movimiento general del robot

float global_us_d;        //Distancia del sonar global
unsigned int global_ir1_luz;  //Luz del IR1 global
unsigned int global_ir2_luz;  //Luz del IR2 global

modos prev_state = MANUAL;  //Estado de DYOR anterior
moviendo manual = PARO;     //Estado de movimiento en el modo manual

unsigned char comunicacion=0; //Cantidad de bytes recibidos por Serial desde el último @ (inicio de bus de datos)
unsigned char comunicacion_max=0; //cantidad de bytes que un bus de datos pretende enviar
bool com_correcto=false;          //Verifica si un bus de datos ha llegado entero hasta * (fin de bus de datos)
unsigned char* mensaje;           //Array con los bytes que se han recibido (incluye el * como carácter final si es correcto)
unsigned long t_mensaje = 0;      //Tiempo desde el último mensaje del bus de datos recibido (si llega a 200 ms se reinicia la comunicación) 

void leer_mensaje_bytes (void){
  switch (mensaje[0]){
    case 48: //Modos DYOR y variables de control
    break;
    case 49:  //Motores
    break;
    case 50:  //Servo (1 byte extra)
      pos_servo=mensaje[1];
    break;
    case 51:  //Laser
      if(mensaje[1]==48) laser_on=false;
      else if(mensaje[1]==49) laser_on=true;
      else if(mensaje[1]==186) laser_on=!laser_on;
    break;
    case 52:  //Sonar
    break;
    case 53:  //Infrarrojos
    break;
    case 54:  //Buzzer
    break;
    case 55:  //LDR
    break;
    
  }
  
}

void bluetooth(void){
  if(Serial.available()>0){
    unsigned int codigo=Serial.read();
    Serial.print("Recibido: ");Serial.println(codigo);
    if(comunicacion==0){ //Modo de comunicación de hasta 255 mensajes (menos número 64)
      if(codigo == 185){  //STOP
        if(dyor_state!=STOP){
          prev_state=dyor_state;
          dyor_state=STOP;
        }
      }
      else if(codigo == 184){ //START
        if(prev_state==MANUAL){
          prev_state=dyor_state;
          dyor_state=MANUAL;
        }
        else if(prev_state==SIGUELINEAS){
          prev_state=dyor_state;
          dyor_state=SIGUELINEAS;
        }
        else if(prev_state==EVITA_PAREDES){
          prev_state=dyor_state;
          dyor_state=EVITA_PAREDES;
        }
        dyor_enable=true;
      }
      else if(codigo == 181){ //EVITA PAREDES
        prev_state=EVITA_PAREDES;
        estado_evitar_paredes = AVANCE;
        dyor_state=STOP;
        Serial.println("SE HA SELECCIONADO EVITAR PAREDES");
      }
      else if(codigo == 182){  //SIGUELINEAS
        prev_state=SIGUELINEAS;
        dyor_state=STOP;
        estado_siguelineas = INIT;
        Serial.println("SE HA SELECCIONADO SIGUELINEAS");
      }
      else if(codigo == 183){ //CONTROL MANUAL
        prev_state=MANUAL;
        dyor_state=STOP;
        Serial.println("SE HA SELECCIONADO CONTROL MANUAL");
      }
      else if(codigo==186) laser_on=!laser_on;  //DISPARO LASER
      else if(codigo==64){//'@'
        comunicacion=1;
      }
      else if(codigo>=0 && codigo<=180){  //SERVO
        pos_servo=codigo;
      }
      else if(codigo>=187 && codigo<=191){  //JOYSTICK
        if(codigo==187){  //Modo manual AVANCE
          manual=AVANCE;
        }
        else if(codigo==188){ //Modo manual GIRO_DERECHA
          manual=GIRO_DERECHA;        
        }
        else if(codigo==189){ //Modo manual RETROCESO
         manual=RETROCESO;        
        }
        else if(codigo==190){ //Modo manual GIRO IZQUIERDA
          manual=GIRO_IZQUIERDA;               
        }
        else if(codigo==191){ //Modo manual PARO
          manual=PARO;                
        }
      }
      else if(codigo==192){ //BUZZER ACTIVO
        silencio=0;
      }
      else if(codigo==193){ //BUZZER SILENCIO
        silencio=1;
        digitalWrite(BUZZER,LOW);
      }
    }
    //*****************************************************************COMUNICACION BYTES**********************************************
    
    if(comunicacion>=2 && comunicacion<=comunicacion_max+3){
      mensaje[comunicacion-2]=codigo;
      comunicacion++;
      t_mensaje=millis();
      if(comunicacion==comunicacion_max+3){
        if(codigo==42){//'*'
          comunicacion=0;
          com_correcto=true;
          Serial.println("MENSAJE RECIBIDO");  
        }
        else{
          comunicacion=0;
          com_correcto=false;
          delete[] mensaje;
        }
      }
    }

    else if(comunicacion==1 && codigo!=64){
      comunicacion_max=codigo-48;
      comunicacion=2;
      t_mensaje=millis();
      mensaje = new unsigned char[comunicacion_max+1]; //Se añadirá también * 
    }
    
  Serial.print("comunicacion = "); Serial.println(comunicacion);
  } //Serial.available()

  if(com_correcto){
    leer_mensaje_bytes();
    comunicacion=0;
    com_correcto=false;
    delete[] mensaje;    
  }
  if(comunicacion>=2 && millis()>=t_mensaje+200 && com_correcto==false){ //si no se llega a cerrar el mensaje en 200 ms, se descarta
    comunicacion=0;
    com_correcto=false;
    delete[] mensaje;
  }
 //*******************************************************************************************************************************************
    /*if(dyor_enable){
      switch(dyor_state){
        case MANUAL:
        set_servo(pos_servo);
        if(disparo(300)){
          laser_on=0;
          //if(estado_mov==PARO)set_velocity(244,244,244,244);   
        }
        else if(pos_servo>=70 && pos_servo<=120 && estado_mov==PARO){
          set_velocity(0,254,0,254);
        }
        
        if(manual==AVANCE){
          set_velocity(140,0,140,0);
          estado_mov=manual;
        }
        else if(manual==RETROCESO){
          set_velocity(0,140,0,140);
          estado_mov=manual; 
        }
        else if(manual==GIRO_DERECHA){
          set_velocity(0,140,140,0);
          estado_mov=GIRO;
        }
        else if(manual==GIRO_IZQUIERDA){
          set_velocity(140,0,0,140);
          estado_mov=GIRO;
        }
        else if(manual==PARO){
          set_velocity(0,0,0,0);
          estado_mov=manual;
        }
        break;

        case SIGUELINEAS:
        if(us_medida()<dist_seguridad){
          //estado_siguelineas=OBSTACULO;
          laser_on=true;
        }
        siguelineas();
        
        break;

        case EVITA_PAREDES:
        evitar_paredes();
        break;

        case STOP:
        dyor_enable = false;
        set_velocity(0,0,0,0);
        estado_mov=PARO;
        laser_on=false;
        disparando=NO_DISPARO;
        disparo(500);
        set_servo(90);
        break;
      }
    }
    else{
      
      global_ir2_luz=ir_medida(IR2);  
      global_ir1_luz=ir_medida(IR1);
      global_us_d=us_medida();
      disparo(500);
    }*/
  
}
