//#include <ESP32Servo.h>
#include <Servo.h>
//#include <analogWrite.h>
//#include "BluetoothSerial.h"


//########################BLUETOOTH#################################
//#include<SoftwareSerial.h> 

/*BLUETOOTH ESP32
 ********************************************** 


#if !defined(CONFIG_BT_ENABLED) || !defined(CONFIG_BLUEDROID_ENABLED)
#error Bluetooth is not enabled! Please run `make menuconfig` to and enable it
#endif

BluetoothSerial BT;

/*DEFINICIÓN DE PINES CONECTADOS
 **********************************************
 */
#define MOTOR_D1 8 //23
#define MOTOR_D2 5 //27
#define MOTOR_I1 12 //13
#define MOTOR_I2 11 //12

#define LASER 4 //19

#define SERVO 9 //16

#define TRIGGER 6//26
#define ECHO 7//25

#define IR1 A0//39 IZQUIERDA
#define IR2 A1  //DERECHA

#define BUZZER 13

/*CONSTANTES DE CONTROL
 ***********************************************
 */
 
const int error_velocidad =  0 ; // Error de velocidad entre los motores en línea recta (siempre se le resta velocidad al motor derecho)
const int offset_rampa =  20;     //Valor inicial para una referencia en rampa
const int sensibilidad_us = 20;    //Variación mínima que puede tener el SONAR entre dos medidas consecutivas sin ponderar su resultado 
const int dist_seguridad = 30 ;   //Distancia a la que el robot para delante de un obstáculo
int t_print = 1000;         //Tiempo para imprimir por el puerto serie todos los parámetros
/*ENUM
 *********************************************
 */
enum moviendo {
  AVANCE,
  RETROCESO,
  GIRO,
  CURVA,
  PARO,
  PARED, //Solo para evitar_paredes
  GIRO_DERECHA,
  GIRO_IZQUIERDA,
  FALLO
};

enum laser {
  NO_DISPARO,
  DISPARO,
  EMERGENCIA
};

enum siguelineas {
  RECTO,
  DERECHA,
  IZQUIERDA,
  INIT,
  OBSTACULO
};

enum modos {
  EVITA_PAREDES,
  SIGUELINEAS,
  MANUAL,
  STOP
};


/*VARIABLES
 *****************************************************
 */
moviendo estado_mov;
moviendo estado_evitar_paredes = AVANCE; //Posibles estados de movimiento al seguir paredes
siguelineas estado_siguelineas = INIT; //Posibles estados de siguelineas
modos dyor_state = MANUAL;  //Programas que ejecuta el dyor

laser disparando = NO_DISPARO;

Servo cabina;
//########################BLUETOOTH#################################
//SoftwareSerial BT(3,2);  


unsigned long t_mov=0;    //Temporizador de movimiento
unsigned long t_serial=0; //Temporizador de puerto serie
unsigned long t_serial0=0;
unsigned long t_serial3=0;
unsigned long t_servo=0; //Temporizador del servo
unsigned long t_laser=0; //Temporizador del laser

int rampa = offset_rampa;  //Valor acumulado de referencia (para poder tener rampas)

float d_us_anterior;


unsigned int pos_servo=90;
bool sentido=1;

bool laser_on=0;
bool silencio=0;

char printed_ir=0;

/* FUNCIONES
 * **********************************************************************
 */

 void set_velocity(int d1_vel, int d2_vel, int i1_vel, int i2_vel){
/* NECESITA INCLUIR LA LIBRERIA analogWrite.h Y DEFINIR LOS PINES DE CONTROL DEL MOTOR
 * SI SE DESCOMENTA EL CÓDIGO ABAJO, CAMBIARÁ EL MOVIMIENTO EN FUNCIÓN DE LOS PARÁMETROS QUE SE LE PASE A LA FUNCIÓN (FALTA REVISAR QUE VAYA BIEN),SE DEBERÁ DEFINIR TAMBIÉN EL ENUM estado_mov SI SE DA EL CASO   
 */
  d1_vel=constrain(d1_vel,0,254);
  d2_vel=constrain(d2_vel,0,254);
  i1_vel=constrain(i1_vel,0,254);
  i2_vel=constrain(i2_vel,0,254);
 
  analogWrite(MOTOR_D1,d1_vel);
  analogWrite(MOTOR_I1,i1_vel);
  analogWrite(MOTOR_D2,d2_vel);
  analogWrite(MOTOR_I2,i2_vel);
  
 //########################BLUETOOTH################################# 
  if(millis()>=t_serial0+t_print){
    //BT.print("V_D1: ");BT.print(d1_vel);BT.print("|| ");BT.print("V_D2: ");BT.print(d2_vel);BT.print("|| ");BT.print("V_I1: ");BT.print(i1_vel);BT.print("|| "); BT.print("V_I2: ");BT.println(i2_vel); 
    t_serial0=millis();   
  }
  
  
  /*if(d1_vel > d2_vel && d2_vel==0){
    if(i1_vel >= i2_vel && i2_vel==0){
      if(i1_vel == d1_vel || i1_vel+error_velocidad == d1_vel) estado_mov=AVANCE;
      else estado_mov=CURVA;
    }
    else if(i1_vel < i2_vel && i1_vel==0) estado_mov=GIRO;
    else estado_mov=FALLO;
  }
  else if(d1_vel < d2_vel && d1_vel==0){
    if(i1_vel <= i2_vel && i1_vel==0){
      if(i2_vel == d2_vel || i2_vel+error_velocidad == d2_vel) estado_mov=RETROCESO;
      else estado_mov=CURVA;
    }
    else if(i1_vel > i2_vel && i2_vel==0) estado_mov=GIRO;
    else estado_mov=FALLO;    
  }
  else estado_mov=FALLO;*/
}

//*****************************************************************************

void dyor_init(void){
  Serial.begin(9600);
  
  //########################BLUETOOTH#################################
  //BT.begin(9600);
    
  pinMode(LASER,OUTPUT);
  pinMode(TRIGGER,OUTPUT);
  pinMode(ECHO,INPUT);
  pinMode(BUZZER,OUTPUT);
  
  cabina.attach(SERVO);

  cabina.write(90);

  
  set_velocity(0,0,0,0);
  estado_mov=PARO;

  estado_evitar_paredes = AVANCE;
  siguelineas estado_siguelineas = INIT;
  dyor_state = MANUAL;

  digitalWrite(LASER,LOW);

  digitalWrite(TRIGGER,LOW);

  digitalWrite(TRIGGER, HIGH);
  delayMicroseconds(10);          //Enviamos un pulso de 10us
  digitalWrite(TRIGGER, LOW); 
  d_us_anterior = pulseIn(ECHO, HIGH)/59.0; //Obtenemos una primera medida de la disttancia del sensor
}

//*****************************************************************

float us_medida (void){
  float t; //Tiempo de vuelo
  float d; //Distancia calculada
  digitalWrite(TRIGGER, HIGH);
  delayMicroseconds(10);          //Enviamos un pulso de 10us
  digitalWrite(TRIGGER, LOW); 
  t = pulseIn(ECHO, HIGH); //Obtenemos el ancho del pulso
  d = t/59.0;
  
  //if(abs(d-d_us_anterior)>=sensibilidad_us) d= d*0.2+d_us_anterior*0.8;
  
  if(millis()>=t_serial+t_print){
 //Imprime la distancia por el puerto serie para comprobar
    Serial.print("Distancia: ");Serial.print(d);Serial.println(" cm");
    
    //########################BLUETOOTH#################################
    //BT.print("Distancia: ");BT.print(d);BT.println(" cm");
    t_serial=millis();
  }
  d_us_anterior=d;
  return d;
}

unsigned int ir_medida(int sensor){
  unsigned int l=analogRead(sensor);
  
  if(millis()>t_serial3+t_print){
    if(sensor == IR1 && printed_ir<2){
    Serial.print("IR1: "); Serial.println(l);
    printed_ir++;
    }
    else if(sensor == IR2 && printed_ir<2){
    Serial.print("IR2: ");Serial.println(l);
    printed_ir++;
    }
    //########################BLUETOOTH#################################
    //BT.print("IR1: "); BT.print(analogRead(IR1));BT.print("|| ");BT.print("IR2: ");BT.println(analogRead(IR2));
    if(printed_ir==2){
      t_serial3=millis();
      printed_ir=0;
    }
 }
 return l;
}

//***************************************************************************

void mov_rampa(int velocidad){
/* NECESITA INCLUIR LA LIBRERIA analogWrite.h, DEFINIR LOS PINES DE CONTROL DEL MOTOR, EL ENUM estado_mov CON EL RESPECTIVO AVANCE, rampa COMO INT Y error_velocidad COMO INT
 * TAMBIÉN NECESITA LA FUNCIÓN set_velocity
 * 
 * SE DEBE LLAMAR CON rampa A 0 o a offset_rampa
 */
    if(velocidad>0){
      if(rampa<velocidad){
        rampa+=1;
        set_velocity(rampa,0,rampa,0);
      }
      else{
        set_velocity(velocidad-error_velocidad,0,velocidad,0);
      }
      estado_mov=AVANCE;
    }
    else if(velocidad<0){
      velocidad=-velocidad;
      if(rampa<velocidad){
        rampa+=1;
        set_velocity(0,rampa,0,rampa);
      }
      else{
        set_velocity(0,velocidad-error_velocidad,0,velocidad);
      }
      estado_mov=RETROCESO;      
    }
    else{
      set_velocity(0,0,0,0);
      estado_mov=PARO;
    }
}

//*****************************************************************************************

bool atras_vuelta(int velocidad, float d){
/*NECESITA INCLUIR LA LIBRERIA analogWrite.h, DEFINIR LOS PINES DE CONTROL DEL MOTOR, EL ENUM estado_mov CON EL RESPECTIVO RETROCESO Y GIRO, dist_seguridad COMO INT Y error_velocidad COMO INT 
 *ADEMÁS DE AJUSTAR LOS TIEMPOS DE ESPERA
 *
 *SE DEBE LLAMAR COMO if(atras_vuelta(velocidad,distancia)) PARA ESPERAR HASTA QUE ACABE
 */
 //Tiempos de espera
  int t1=100;
  int t2=240;
  int t3=250;
  
  if(d<dist_seguridad+10){
    mov_rampa(-velocidad);
    //set_velocity(0,velocidad,0,velocidad);
    estado_mov=RETROCESO;
    t_mov=millis();
    return 0;
  }
  else if(millis()<t_mov+t1){
    set_velocity(0,0,0,0);   
    estado_mov=PARO;
    return 0;
  }
  else if(millis()>=t_mov+t1 && millis()<t_mov+t1+t2){
    set_velocity(130,0,0,130);     
    estado_mov=GIRO;
    return 0;
  }
  else if(millis()>=t_mov+t1+t2 && millis()<t_mov+t1+t2+t3){
    set_velocity(254,254,254,254);
    estado_mov=PARO;
    return 0;
  }
  else{
    t_mov=0;
    return 1;
  }
 }
 
//********************************************************************************

void set_servo(unsigned int posicion){
  posicion = constrain(posicion,0,180);
  cabina.write(posicion);
  t_servo=millis();  
}

void vuelta_servo(void){
  if(millis()>=t_servo+50){
  if(sentido)pos_servo+=1;
  else pos_servo-=1;
  
  set_servo(pos_servo);
  if(pos_servo==180) sentido=0;
  else if(pos_servo==0) sentido=1;
  }
}
//******************************************************************************

char disparo(int ms){

  switch(disparando){
    case DISPARO:
    digitalWrite(LASER,HIGH);
    if(!silencio)
      digitalWrite(BUZZER,HIGH);
    if(millis()>=t_laser+ms){
      disparando=NO_DISPARO;
      t_laser=millis();
      return 0;
    }
    break;

    case NO_DISPARO:
    digitalWrite(LASER,LOW);
    digitalWrite(BUZZER,LOW);
    if(millis()>=t_laser+ms*2 && laser_on){
      disparando=DISPARO;
      t_laser=millis();
    }
    return 1;
    break;

    case EMERGENCIA:
    digitalWrite(LASER,LOW);
    digitalWrite(BUZZER,LOW);
    Serial.print("Error láser | ");
    return 1;
    break;    
  }
}
